DROP PROCEDURE [hips].[ClinicalDocumentList]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew
-- Create date: 02 April 2012
-- Description:   Gets all records from the Pcehrs Table
-- 08/10/2012 - gmassey - Changed Pcehr table to ClinicalDocument
-- =============================================
CREATE PROCEDURE [hips].[ClinicalDocumentList] 
(
	@dateLastUpdated AS DATE = NULL
)
AS
BEGIN
SELECT  p.ClinicalDocumentId,
		p.SourceSystemSetId,
		p.EpisodeId,
		p.DocumentTypeId,
		p.DateCreated,
		p.UserCreated,
		p.DateModified,
		p.UserModified
		
FROM  hips.ClinicalDocument p
WHERE p.DateModified > @dateLastUpdated OR @dateLastUpdated IS NULL
END
GO

